

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

//import javax.swing.JButton;
//import javax.swing.JFrame;

public class TinyHttpServer_Multithread {
	private ServerSocket server;

	public TinyHttpServer_Multithread() throws IOException {
		server = new ServerSocket(80);
		System.out.println("Server starts...listen to port 80");
	}

	public void startServer() throws IOException {
		//makeGUI();
		while (true) {
			Socket client = server.accept();
			ProcessingUnit pUnit = new ProcessingUnit(client);
			pUnit.start();
			
		}
	}
/*
	private void makeGUI() {
		JFrame frame = new JFrame("TinyHttpServer");
		frame.setUndecorated(true);
		Container c = frame.getContentPane();
		JButton closeButton = new JButton("Close!");
		closeButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				release();
				System.exit(0);
			}
		});
		c.add(closeButton);
		frame.setSize(200, 200);
		frame.setLocation(100, 100);
		frame.setVisible(true);
	}
*/
	private void release() {
		try {
			server.close();
			System.out.println("Release port 80.");
		} catch (IOException e) {
			// Just close the server and ignore the warnings
		}
	}

	public static void main(String[] args) {
		try {
			TinyHttpServer_Multithread obj = new TinyHttpServer_Multithread();
			obj.startServer();
		} catch (IOException e) {
			System.out.println("Socket closed.");
		}
	}

}






